definition module StdMenu


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.1
//	
//	StdMenu defines functions on menus.
//	********************************************************************************


import	StdMenuDef, StdMenuElementClass
from	iostate		import PSt, IOSt


//	Operations on unknown Ids are ignored.

class Menus mdef where
	openMenu	:: .ls !(mdef .ls (PSt .l .p)) !(PSt .l .p)
							   -> (!ErrorReport,!PSt .l .p)
	getMenuType	::      (mdef .ls .ps)	-> MenuType
/*	Open the given menu definition for this interactive process. 
	openMenu may not be permitted to open a menu depending on its DocumentInterface 
		(see the comments at the shareProcesses instances in module StdProcess).
	In case a menu with the same Id is already open then nothing happens. In case 
		the menu has the WindowMenuId Id then nothing happens. In case the menu does
		not have an Id, it will obtain an Id which is fresh with respect to the 
		current set of menus. The Id can be reused after closing this menu. In case 
		menu elements are opened with duplicate Ids, the menu will not be opened.
	In case the menu definition does not have a MenuIndex attribute (see StdMenuDef)
		it will be opened behind the last menu. In case the menu definition has a 
		MenuIndex attribute it will be placed behind the menu indicated by the 
		integer index. 
		The index of a menu starts from one for the first present menu. If the index
		is negative or zero, then the new menu is added before the first menu. If 
		the index exceeds the number of menus, then the new menu is added behind the
		last menu.
*/

instance Menus	(Menu m)	| MenuElements m


closeMenu :: !Id !(IOSt .l .p) -> IOSt .l .p
/*	closeMenu closes the indicated Menu and all of its elements.
	The WindowMenu can not be closed by closeMenu (in case the Id argument equals 
	WindowMenuId).
*/


openMenuElements	:: !Id     !Index .ls (m .ls (PSt .l .p))      !(IOSt .l .p)
												   -> (!ErrorReport,!IOSt .l .p)
												   |  MenuElements m
openSubMenuElements	:: !Id !Id !Index .ls (m .ls (PSt .l .p))      !(IOSt .l .p)
												   -> (!ErrorReport,!IOSt .l .p)
												   |  MenuElements m
openRadioMenuItems	:: !Id !Id !Index ![MenuRadioItem (PSt .l .p)] !(IOSt .l .p)
												   -> (!ErrorReport,!IOSt .l .p)
/*	Add menu elements to the indicated Menu, SubMenu, or RadioMenu.
	openMenuElements: 
		adds menu elements to the Menu identified by the Id argument. 
	openSubMenuElements:
		adds menu elements to the SubMenu identified by the second Id argument, 
		which must be contained in the Menu identified by the first Id argument.
	openRadioMenuItems:
		adds menu radio items to the RadioMenu identified by the second Id argument, 
		which must be contained in the Menu identified by the first Id argument. 
		If the RadioMenu was empty, then the first item in the list will be checked. 
	Menu elements are added after the item with the specified index. The index of a 
		menu element starts from one for the first menu element in the indicated 
		menu. 
		If the index is negative or zero, then the new menu elements are added
		before the first menu element of the indicated menu. 
		If the index exceeds the number of menu elements in the indicated menu, then
		the new menu elements are added behind the last menu element of the 
		indicated menu. 
	No menu elements are added if the indicated menu does not exist.
	open(Sub)MenuElements have no effect in case menu elements with duplicate Ids 
	are opened.
*/


closeMenuElements :: !Id ![Id] !(IOSt .l .p) -> IOSt .l .p
/*	closeMenuElements
		closes menu elements of the Menu identified by the first Id argument by 
		their Ids. The elements of (Sub/Radio)Menus will be removed first.  
*/


closeMenuIndexElements		:: !Id     ![Index]	!(IOSt .l .p) -> IOSt .l .p
closeSubMenuIndexElements	:: !Id !Id ![Index]	!(IOSt .l .p) -> IOSt .l .p
closeRadioMenuIndexElements	:: !Id !Id ![Index]	!(IOSt .l .p) -> IOSt .l .p
/*	Close menu elements of the indicated Menu, SubMenu, or RadioMenu by their Index 
	position.
	closeMenuIndexElements:
		closes menu elements of the Menu identified by the Id argument. 
	closeSubMenuIndexElements:
		closes menu elements of the SubMenu identified by the second Id argument, 
		which must be contained in the Menu identified by the first Id argument.
	closeRadioMenuIndexElements:
		closes menu items of the RadioMenu identified by the second Id argument, 
		which must be contained in the Menu identified by the first Id argument. 
	Analogous to openMenuElements and openRadioMenuItems indices range from one to 
		the number of menu elements in a menu. Invalid indices (less than one or 
		larger than the number of menu elements of the menu) are ignored.
	If the currently checked element of a RadioMenu is closed, the first remaining 
		element of that RadioMenu will be checked. 
	Closing a (Sub/Radio)Menu closes the indicated (Sub/Radio)Menu and all of its 
	elements.
*/


enableMenuSystem :: !(IOSt .l .p) -> IOSt .l .p
disableMenuSystem:: !(IOSt .l .p) -> IOSt .l .p
/*	Enable/disable the menu system of this interactive process. When the menu system
	is re-enabled the previously selectable menus and elements will become 
	selectable again. 
	Enable/disable operations on the menu(element)s of a disabled menu system take 
	effect when the menu system is re-enabled. 
	enableMenuSystem has no effect in case the interactive process has a (number of)
	modal dialogue(s).
*/


enableMenus :: ![Id] !(IOSt .l .p) -> IOSt .l .p
disableMenus:: ![Id] !(IOSt .l .p) -> IOSt .l .p
/*	Enable/disable individual menus. 
	The WindowMenu can not be enabled/disabled.
	Disabling a menu overrules the SelectStates of its elements, which become 
	unselectable.
	Enabling a disabled menu re-establishes the SelectStates of its elements.
	Enable/disable operations on the elements of a disabled menu take effect when 
	the menu is re-enabled.
*/


getMenuSelectState :: !Id !(IOSt .l .p) -> (!Maybe SelectState,!IOSt .l .p)
/*	getMenuSelectState yields the current SelectState of the indicated menu. In case
	the menu does not exist, Nothing is returned.
*/


getMenus :: !(IOSt .l .p) -> (![(Id,MenuType)],!IOSt .l .p)
/*	getMenus yields the Ids and MenuTypes of the current set of menus of this 
	interactive process.
*/


getMenuPos :: !Id !(IOSt .l .p) -> (!Maybe Index,!IOSt .l .p)
/*	getMenuPos yields the index position of the indicated menu in the current list 
	of menus.
	In case the menu does not exist, Nothing is returned.
*/


setMenuTitle :: !Id !Title !(IOSt .l .p) -> IOSt .l .p
getMenuTitle :: !Id        !(IOSt .l .p) -> (!Maybe Title,!IOSt .l .p)
/*	setMenuTitle sets the title of the indicated menu. 
		In case the menu does not exist or refers to the WindowMenu, nothing 
		happens.
	getMenuTitle retrieves the current title of the indicated menu. 
		In case the menu does not exist, Nothing is returned.
*/
